/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.service;

import com.vcard.vcardapplication.dao.UserDao;
import com.vcard.vcardapplication.model.Role;
import com.vcard.vcardapplication.model.User;
import com.vcard.vcardapplication.repository.UserRepository;
import com.vcard.vcardapplication.request.PasswordChangeRequest;
import com.vcard.vcardapplication.request.UserRequest;
import com.vcard.vcardapplication.response.AuthenticationResponse;
import com.vcard.vcardapplication.response.UserLoginResponse;
import com.vcard.vcardapplication.security.JwtService;
import com.vcard.vcardapplication.service.AuthenticationService;
import java.util.Base64;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationServiceImpl
implements AuthenticationService {
    public final UserRepository userRepository;
    @Autowired
    private PasswordEncoder encoder;
    private final JwtService jwtService;
    private final AuthenticationManager authenticationManager;
    @Autowired
    UserDao userDao;

    public AuthenticationResponse register(UserRequest request) {
        User user = User.builder().firstname(request.getFirstname()).email(request.getEmail()).password(this.encoder.encode((CharSequence)request.getPassword())).mobile(request.getMobile()).role(Role.USER).build();
        this.userRepository.save((Object)user);
        String jwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(jwtToken).build();
    }

    public AuthenticationResponse authenticate(UserRequest request) {
        this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getEmail(), (Object)request.getPassword()));
        User user = (User)this.userRepository.findByEmail(request.getEmail()).orElseThrow(() -> new UsernameNotFoundException("User not found"));
        String JwtToken = this.jwtService.generateToken((UserDetails)user);
        return AuthenticationResponse.builder().token(JwtToken).build();
    }

    public UserLoginResponse getDetails(String as) {
        String bearer = as.substring(as.indexOf(".") + 1);
        String bearers = (String)bearer.subSequence(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearers));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEamil(userName);
        UserLoginResponse response = new UserLoginResponse();
        response.setEmail(((User)creator.get()).getEmail());
        response.setFirstname(((User)creator.get()).getFirstname());
        response.setMobile(((User)creator.get()).getMobile());
        response.setRole(((User)creator.get()).getRole());
        response.setId(((User)creator.get()).getId());
        return response;
    }

    public PasswordChangeRequest getPassDetails(String as) {
        String bearer = as.substring(as.indexOf(".") + 1);
        String bearers = bearer.substring(0, bearer.indexOf("."));
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String token = new String(decoder.decode(bearers));
        JSONObject jsonObject = new JSONObject(token);
        String userName = jsonObject.getString("sub");
        Optional creator = this.userDao.findByEamil(userName);
        if (creator.isPresent()) {
            PasswordChangeRequest res = new PasswordChangeRequest();
            User user = (User)creator.get();
            res.setOldpassword(user.getPassword());
            return res;
        }
        throw new RuntimeException("Error:User not found");
    }

    public void pass() {
        System.out.println("password" + this.encoder.encode((CharSequence)"2020"));
    }

    public ResponseEntity<?> checkEmail(String email) {
        try {
            Optional user = this.userDao.findByEmail(email);
            if (user.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Email ID is already present");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)"Email ID is Available");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while email:" + e.getMessage());
        }
    }

    public ResponseEntity<?> checkMobile(Long mobile) {
        try {
            Optional user = this.userDao.findByMobile(mobile);
            if (user.isPresent()) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Mobile number is already present");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)"Mobile number is Availabe");
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while mobile:" + e.getMessage());
        }
    }

    @Generated
    public AuthenticationServiceImpl(UserRepository userRepository, JwtService jwtService, AuthenticationManager authenticationManager) {
        this.userRepository = userRepository;
        this.jwtService = jwtService;
        this.authenticationManager = authenticationManager;
    }
}

