/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.service;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.vcard.vcardapplication.dao.FileDAO;
import com.vcard.vcardapplication.model.FileModel;
import com.vcard.vcardapplication.request.ResponseBannerDto;
import com.vcard.vcardapplication.service.FileService;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserPhotoService {
    @Autowired
    private FileService fileService;
    @Autowired
    private FileDAO fileDAO;

    public ResponseBannerDto addprofile(MultipartFile file) {
        try {
            if (file.isEmpty()) {
                throw new IllegalArgumentException("file cannot be empty");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                throw new IllegalArgumentException("Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/tapfolio/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.tapfolio.in" + remotePath;
            ResponseBannerDto bannerDto = new ResponseBannerDto(uploadedUrl);
            return new ResponseBannerDto(uploadedUrl);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error occurred while processing the file: " + e.getMessage());
        }
    }

    public byte[] generateQRCodeImage(String text, int width, int height) throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, ErrorCorrectionLevel> hints = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        BitMatrix bitMatrix = qrCodeWriter.encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage qrImage = MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        URL logoUrl = new URL("https://storage.tapfolio.in/tapfolio/26042025190205492.png");
        BufferedImage logo = ImageIO.read(logoUrl);
        int logoSize = width / 5;
        BufferedImage resizedLogo = new BufferedImage(logoSize, logoSize, 2);
        Graphics2D g2dLogo = resizedLogo.createGraphics();
        g2dLogo.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2dLogo.drawImage(logo, 0, 0, logoSize, logoSize, null);
        g2dLogo.dispose();
        Graphics2D g = qrImage.createGraphics();
        int centerX = (qrImage.getWidth() - logoSize) / 2;
        int centerY = (qrImage.getHeight() - logoSize) / 2;
        g.setColor(Color.WHITE);
        g.fillRoundRect(centerX, centerY, logoSize, logoSize, 20, 20);
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage((Image)resizedLogo, centerX, centerY, null);
        g.dispose();
        ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)pngOutputStream);
        return pngOutputStream.toByteArray();
    }

    public ResponseEntity<?> add(MultipartFile file) {
        try {
            System.out.println("");
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("ddMMyyyyHHmmssSSS");
            LocalDateTime current = LocalDateTime.now();
            String extension = file.getContentType();
            if (extension == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Invalid file type.");
            }
            String exe = extension.substring(extension.lastIndexOf("/") + 1);
            String fileName = dtf.format(current) + "." + exe;
            String remotePath = "/tapfolio/" + fileName;
            this.fileService.upload(remotePath, file);
            String uploadedUrl = "https://storage.tapfolio.in" + remotePath;
            FileModel fileModel = new FileModel();
            fileModel.setFilelink(uploadedUrl);
            fileModel = this.fileDAO.save(fileModel);
            ResponseBannerDto response = new ResponseBannerDto(fileModel.getFileid(), uploadedUrl);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error occurred: " + e.getMessage()));
        }
    }
}

