/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.controller;

import com.google.zxing.WriterException;
import com.vcard.vcardapplication.model.User;
import com.vcard.vcardapplication.request.ResponseBannerDto;
import com.vcard.vcardapplication.request.UserRequest;
import com.vcard.vcardapplication.service.UserPhotoService;
import com.vcard.vcardapplication.service.UserService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    private UserPhotoService photoService;

    @PostMapping(value={"/save"})
    public ResponseEntity<User> createUser(@RequestBody UserRequest request) {
        try {
            User user = this.userService.createUser(request);
            return ResponseEntity.ok((Object)user);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<List<User>> getall() {
        try {
            List users = this.userService.getall();
            return ResponseEntity.ok((Object)users);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/findbyid"})
    public ResponseEntity<?> getUserById(@RequestParam Long id) {
        try {
            Optional optional = this.userService.getUserById(id);
            return ResponseEntity.ok((Object)optional);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(null);
        }
    }

    @DeleteMapping(value={"/delete"})
    public ResponseEntity<?> deleteUserById(@RequestParam Long id) {
        try {
            this.userService.deleteUserById(id);
            return ResponseEntity.ok((Object)"User id is delete successfully");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/uploadphoto"})
    public ResponseBannerDto addprofile(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.photoService.addprofile(file);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while add profile");
        }
    }

    @PutMapping(value={"/mail"})
    public String sendMailVcard(@RequestBody UserRequest request) {
        Long id = request.getId();
        String email = request.getEmail();
        return this.userService.sendMailVcard(id, email);
    }

    @PutMapping(value={"/{shorturl}"})
    public ResponseEntity<?> findByShortUrl(@PathVariable String shorturl) {
        try {
            User userOptional = this.userService.findByShortUrl(shorturl);
            return ResponseEntity.ok((Object)userOptional);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/"})
    public ResponseEntity<ByteArrayInputStream> generateVcf() {
        String vcfContent = "BEGIN:VCARD\nVERSION:3.0\nFN:John Doe\nORG:Example Inc.\nTITLE:Software Engineer\nTEL;TYPE=WORK,VOICE:+1234567890\nEMAIL;TYPE=PREF,INTERNET:johndoe@example.com\nEND:VCARD";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(vcfContent.getBytes(StandardCharsets.UTF_8));
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=\"contact.vcf\"");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.parseMediaType((String)"text/vcard")).body((Object)inputStream);
    }

    @PutMapping(value={"/createShorturlQr"})
    public String createShorturlQr() throws WriterException, IOException {
        return this.userService.createShorturlQr();
    }

    @PostMapping(value={"/multi-photo"})
    public ResponseEntity<?> multiImage(MultipartFile file) {
        try {
            return this.photoService.add(file);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while addprofile" + e.getMessage());
        }
    }
}

