/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.controller;

import com.vcard.vcardapplication.request.PasswordChangeRequest;
import com.vcard.vcardapplication.request.UserDto;
import com.vcard.vcardapplication.service.AuthenticationService;
import com.vcard.vcardapplication.service.PasswordChangeServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/auth"})
public class AuthenticationController {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private PasswordChangeServiceImpl changeService;

    @PostMapping(value={"/change-password"})
    public ResponseEntity<?> changePassword(@RequestBody PasswordChangeRequest changeRequest, @RequestHeader(value="Authorization") String token) {
        try {
            return this.changeService.changePassword(changeRequest, token);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while changing password.");
        }
    }

    @PutMapping(value={"/forgotpassword"})
    public ResponseEntity<?> forgotpassword(@RequestBody UserDto request) throws Exception {
        return ResponseEntity.ok((Object)this.changeService.forgotPassword(request));
    }

    @PutMapping(value={"/sendotp"})
    public ResponseEntity<?> sendotp(@RequestBody UserDto request) throws Exception {
        return ResponseEntity.ok((Object)this.changeService.sendOtp(request));
    }

    @PutMapping(value={"/checkemail"})
    public ResponseEntity<?> checkEmail(@RequestParam String email) {
        try {
            return this.authenticationService.checkEmail(email);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while check email" + e.getMessage()));
        }
    }

    @PutMapping(value={"/checkmobile"})
    public ResponseEntity<?> checkMobile(@RequestParam Long mobile) {
        try {
            return this.authenticationService.checkMobile(mobile);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while check mobile" + e.getMessage()));
        }
    }

    @PutMapping(value={"/otpverification"})
    public ResponseEntity<String> otpverification(@RequestBody UserDto userDto) {
        try {
            String string = this.changeService.otpverification(userDto);
            return ResponseEntity.ok((Object)string);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("An error occurred while otp verification" + e.getMessage()));
        }
    }
}

