/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QRCodeController {
    @PutMapping(value={"/api/v1/download-qrcode"})
    public ResponseEntity<byte[]> downloadQRCode(@RequestBody Map<String, String> request) {
        String imageUrl = request.get("imageUrl");
        try {
            URL url = new URL(imageUrl);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestProperty("Accept", "image/png,image/*;q=0.8");
            String contentType = connection.getContentType();
            if (contentType == null || !contentType.startsWith("image")) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE).body((Object)("Invalid image. Content type: " + contentType).getBytes());
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (InputStream input = connection.getInputStream();){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"qrcode.png\""})).contentType(MediaType.parseMediaType((String)contentType)).body((Object)output.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download image: " + e.getMessage()).getBytes());
        }
    }
}

