/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.web.multipart.MultipartFile;

public class ByteArrayResourceMultipartFile
implements MultipartFile {
    private final ByteArrayResource byteArrayResource;
    private final String fileName;
    private final String contentType;

    public ByteArrayResourceMultipartFile(ByteArrayResource byteArrayResource, String fileName, String contentType) {
        this.byteArrayResource = byteArrayResource;
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public String getOriginalFilename() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.byteArrayResource.contentLength() == 0L;
    }

    public long getSize() {
        return this.byteArrayResource.contentLength();
    }

    public byte[] getBytes() throws IOException {
        return this.byteArrayResource.getByteArray();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArrayResource.getByteArray());
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        try (FileOutputStream outputStream = new FileOutputStream(dest);){
            byte[] bytes = this.byteArrayResource.getByteArray();
            outputStream.write(bytes);
        }
    }
}

