/*
 * Decompiled with CFR 0.152.
 */
package com.vcard.vcardapplication.service;

import com.google.zxing.WriterException;
import com.vcard.vcardapplication.dao.FileDAO;
import com.vcard.vcardapplication.dao.UserDao;
import com.vcard.vcardapplication.model.FileModel;
import com.vcard.vcardapplication.model.Role;
import com.vcard.vcardapplication.model.User;
import com.vcard.vcardapplication.request.ResponseBannerDto;
import com.vcard.vcardapplication.request.UserRequest;
import com.vcard.vcardapplication.service.ByteArrayResourceMultipartFile;
import com.vcard.vcardapplication.service.UserPhotoService;
import com.vcard.vcardapplication.service.UserService;
import com.vcard.vcardapplication.util.JavaSendapi;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private FileDAO fileDAO;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private UserPhotoService userPhotoService;
    @Autowired
    private JavaSendapi emailsend;
    private static final String CHAR_POOL = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final int CODE_LENGTH = 6;
    private final Set<String> generatedCodes = new HashSet();
    private final Random random = new Random();

    public User createUser(UserRequest request) {
        try {
            User user;
            boolean isNewUser = false;
            Optional optional = this.userDao.findById(request.getId());
            if (optional.isPresent()) {
                user = (User)optional.get();
            } else {
                user = new User();
                isNewUser = true;
            }
            if (request.getPrefix() != null) {
                user.setPrefix(request.getPrefix());
            }
            if (request.getFirstname() != null) {
                user.setFirstname(request.getFirstname());
            }
            if (request.getLastname() != null) {
                user.setLastname(request.getLastname());
            }
            if (request.getMiddlename() != null) {
                user.setMiddlename(request.getMiddlename());
            }
            if (request.getSuffix() != null) {
                user.setSuffix(request.getSuffix());
            }
            if (request.getNickname() != null) {
                user.setNickname(request.getNickname());
            }
            if (request.getOrganization() != null) {
                user.setOrganization(request.getOrganization());
            }
            if (request.getTitle() != null) {
                user.setTitle(request.getTitle());
            }
            if (request.getWorkurl() != null) {
                user.setWorkurl(request.getWorkurl());
            }
            if (request.getRole() != null) {
                user.setRole(Role.USER);
            }
            if (request.getEmail() != null) {
                user.setEmail(request.getEmail());
            }
            if (request.getWorkemail() != null) {
                user.setWorkemail(request.getWorkemail());
            }
            if (request.getHomephone() != null) {
                user.setHomephone(request.getHomephone());
            }
            if (request.getWorkphone() != null) {
                user.setWorkphone(request.getWorkphone());
            }
            if (request.getPagerphone() != null) {
                user.setPagerphone(request.getPagerphone());
            }
            if (request.getHomefax() != null) {
                user.setHomefax(request.getHomefax());
            }
            if (request.getWorkfax() != null) {
                user.setWorkfax(request.getWorkfax());
            }
            if (request.getHomelabel() != null) {
                user.setHomelabel(request.getHomelabel());
            }
            if (request.getHomestreet() != null) {
                user.setHomestreet(request.getHomestreet());
            }
            if (request.getHomecity() != null) {
                user.setHomecity(request.getHomecity());
            }
            if (request.getHomestate() != null) {
                user.setHomestate(request.getHomestate());
            }
            if (request.getHomepostalcode() != null) {
                user.setHomepostalcode(request.getHomepostalcode());
            }
            if (request.getHomecountry() != null) {
                user.setHomecountry(request.getHomecountry());
            }
            if (request.getWorklebal() != null) {
                user.setWorklebal(request.getWorklebal());
            }
            if (request.getWorkstreet() != null) {
                user.setWorkstreet(request.getWorkstreet());
            }
            if (request.getWorkcity() != null) {
                user.setWorkcity(request.getWorkcity());
            }
            if (request.getWorkstate() != null) {
                user.setWorkstate(request.getWorkstate());
            }
            if (request.getWorkpostalcode() != null) {
                user.setWorkpostalcode(request.getWorkpostalcode());
            }
            if (request.getWorkcountry() != null) {
                user.setWorkcountry(request.getWorkcountry());
            }
            if (request.getBirthday() != null) {
                user.setBirthday(request.getBirthday());
            }
            if (request.getAnnivesary() != null) {
                user.setAnnivesary(request.getAnnivesary());
            }
            if (request.getGender() != null) {
                user.setGender(request.getGender());
            }
            user.setProfileimage(request.getProfileimage() != null ? request.getProfileimage() : "https://storage.megashop.my/FindClub/16112024173529016.png");
            if (request.getLogo() != null) {
                user.setLogo(request.getLogo());
            }
            if (request.getLinkedin() != null) {
                user.setLinkedin(request.getLinkedin());
            }
            if (request.getTwitter() != null) {
                user.setTwitter(request.getTwitter());
            }
            if (request.getFacebook() != null) {
                user.setFacebook(request.getFacebook());
            }
            if (request.getInstagram() != null) {
                user.setInstagram(request.getInstagram());
            }
            if (request.getYoutube() != null) {
                user.setYoutube(request.getYoutube());
            }
            if (request.getCustomUrl() != null) {
                user.setCustomUrl(request.getCustomUrl());
            }
            if (request.getCustomname() != null) {
                user.setCustomname(request.getCustomname());
            }
            if (request.getNote() != null) {
                user.setNote(request.getNote());
            }
            if (request.getUid() != null) {
                user.setUid(request.getUid());
            }
            if (request.getMobile() != null) {
                user.setMobile(request.getMobile());
            }
            if (request.getWorkrole() != null) {
                user.setWorkrole(request.getWorkrole());
            }
            if (request.getLocation() != null) {
                user.setLocation(request.getLocation());
            }
            if (request.getServices() != null) {
                user.setServices(request.getServices());
            }
            user.getFileids().clear();
            user.getImagegallery().clear();
            List newFileIds = request.getFileids();
            ArrayList<String> newImageGallery = new ArrayList<String>();
            for (Long fileid : newFileIds) {
                Optional imgopt = this.fileDAO.findById(fileid);
                if (!imgopt.isPresent()) continue;
                newImageGallery.add(((FileModel)imgopt.get()).getFilelink());
            }
            user.setFileids(newFileIds);
            user.setImagegallery(newImageGallery);
            if (user.getShorturl() == null || user.getQrcode() == null) {
                String var = this.generateUniqueCode();
                String url = "https://app.tapfolio.in/" + var;
                user.setShorturl(var);
                byte[] qrCodeBytes = this.userPhotoService.generateQRCodeImage(url, 250, 250);
                ByteArrayResourceMultipartFile qrCodeFile = new ByteArrayResourceMultipartFile(new ByteArrayResource(qrCodeBytes), "QRCode.png", "image/png");
                ResponseBannerDto qrCodeUrl = this.userPhotoService.addprofile((MultipartFile)qrCodeFile);
                if (user.getQrcode() == null) {
                    user.setQrcode(qrCodeUrl.getUploadedUrl().toString());
                }
            }
            return this.userDao.createUser(user);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while create user" + e.getMessage());
        }
    }

    public List<User> getall() {
        try {
            List users = this.userDao.getall();
            if (users == null || users.isEmpty()) {
                throw new RuntimeException("No users found.");
            }
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while getall");
        }
    }

    public Optional<User> getUserById(Long id) {
        try {
            Optional users = this.userDao.findById(id);
            if (users.isEmpty()) {
                throw new RuntimeException("user is not found");
            }
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while getuser by id");
        }
    }

    public void deleteUserById(Long id) {
        try {
            this.userDao.deleteUserById(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public User findByShortUrl(String shorturl) {
        try {
            Optional useOptional = this.userDao.findByShortUrl(shorturl);
            if (useOptional.isEmpty()) {
                throw new RuntimeException("Short url not found");
            }
            return (User)useOptional.get();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while find shorturl" + e.getMessage());
        }
    }

    public String sendMailVcard(Long id, String email) {
        try {
            System.out.println("Attempting to retrieve user with ID: " + id);
            Optional users = this.userDao.findById(id);
            if (users.isEmpty()) {
                System.out.println("User with ID " + id + " not found.");
                throw new RuntimeException("User not found");
            }
            User user = (User)users.get();
            System.out.println("User retrieved: " + user);
            byte[] vcard = this.createVCard(user);
            System.out.println("vCard created, byte array length: " + vcard.length);
            this.emailsend.sendMailWithAttachment(email, "Download V-card", "Please find the attached V-card.", vcard);
            System.out.println("Email sent to: " + email);
            return "V-card sent to email successfully!";
        }
        catch (Exception e) {
            System.out.println("Error occurred: " + e.getMessage());
            throw new RuntimeException("An error occurred while retrieving user details", e);
        }
    }

    public byte[] createVCard(User contact) throws IOException {
        System.out.println("Creating vCard for user: " + contact);
        String vCardContent = "BEGIN:VCARD\nVERSION:3.0\nFN:" + contact.getFirstname() + " " + contact.getLastname() + "\nN:" + contact.getLastname() + ";" + contact.getFirstname() + ";" + contact.getMiddlename() + ";;\nPREFIX:" + contact.getPrefix() + "\nSUFFIX:" + contact.getSuffix() + "\nNICKNAME:" + contact.getNickname() + "\nORG:" + contact.getOrganization() + "\nTITLE:" + contact.getTitle() + "\nURL:" + contact.getWorkurl() + "\nEMAIL:" + contact.getEmail() + "\nWORKEMAIL:" + contact.getWorkemail() + "\nTEL;TYPE=HOME:" + contact.getHomephone() + "\nTEL;TYPE=WORK:" + contact.getWorkphone() + "\nTEL;TYPE=CELL:" + contact.getMobile() + "\nTEL;TYPE=PAGER:" + contact.getPagerphone() + "\nTEL;TYPE=FAX:" + contact.getHomefax() + "\nTEL;TYPE=WORK,FAX:" + contact.getWorkfax() + "\nADR;TYPE=HOME:" + contact.getHomelabel() + ";" + contact.getHomestreet() + ";" + contact.getHomecity() + ";" + contact.getHomestate() + ";" + contact.getHomepostalcode() + ";" + contact.getHomecountry() + "\nADR;TYPE=WORK:" + contact.getWorklebal() + ";" + contact.getWorkstreet() + ";" + contact.getWorkcity() + ";" + contact.getWorkstate() + ";" + contact.getWorkpostalcode() + ";" + contact.getWorkcountry() + "\nBDAY:" + contact.getBirthday() + "\nANNIVERSARY:" + contact.getAnnivesary() + "\nGENDER:" + contact.getGender() + "\nPHOTO;VALUE=URL:" + contact.getProfileimage() + "\nLOGO;VALUE=URL:" + contact.getLogo() + "\nX-SOCIALPROFILE;TYPE=LINKEDIN:" + contact.getLinkedin() + "\nX-SOCIALPROFILE;TYPE=TWITTER:" + contact.getTwitter() + "\nX-SOCIALPROFILE;TYPE=FACEBOOK:" + contact.getFacebook() + "\nX-SOCIALPROFILE;TYPE=INSTAGRAM:" + contact.getInstagram() + "\nX-SOCIALPROFILE;TYPE=YOUTUBE:" + contact.getYoutube() + "\nX-SOCIALPROFILE;TYPE=CUSTOM:" + contact.getCustomUrl() + "\nNOTE:" + contact.getNote() + "\nUID:" + contact.getUid() + "\nWORKROLE:" + contact.getWorkrole() + "\nIMAGE:" + contact.getImage() + "\nLOCATION:" + contact.getLocation() + "\nEND:VCARD";
        System.out.println("vCard content length: " + vCardContent.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(vCardContent.getBytes());
        System.out.println("vCard byte array generated.");
        return byteArrayOutputStream.toByteArray();
    }

    public String generateUniqueCode() {
        String code;
        while (this.generatedCodes.contains(code = this.generateRandomCode())) {
        }
        this.generatedCodes.add(code);
        return code;
    }

    private String generateRandomCode() {
        StringBuilder code = new StringBuilder(6);
        for (int i = 0; i < 6; ++i) {
            code.append(CHAR_POOL.charAt(this.random.nextInt(CHAR_POOL.length())));
        }
        return code.toString();
    }

    public String createShorturlQr() throws WriterException, IOException {
        String var = this.generateUniqueCode();
        String url = "https://app.tapfolio.in/GjFAYa";
        byte[] qrCodeBytes = this.userPhotoService.generateQRCodeImage(url, 250, 250);
        ByteArrayResourceMultipartFile qrCodeFile = new ByteArrayResourceMultipartFile(new ByteArrayResource(qrCodeBytes), "QRCode.png", "image/png");
        ResponseBannerDto qrCodeUrl = this.userPhotoService.addprofile((MultipartFile)qrCodeFile);
        return qrCodeUrl.getUploadedUrl().toString();
    }
}

